<?php 
/**
 * SMOF Interface
 *
 * @package	 WordPress
 * @subpackage  SMOF
 * @since	   1.4.0
 * @author	  Syamil MJ
 */
 
 
/**
 * Admin Init
 *
 * @uses wp_verify_nonce()
 * @uses header()
 *
 * @since 1.0.0
 */
function optionsframework_admin_init() 
{
	// Rev up the Options Machine
	global $of_options, $options_machine;

	$options_machine = new Options_Machine($of_options);

	if (!of_get_options()) {
		of_save_options($options_machine->Defaults);
	}
	
	$smof_data = of_get_options();
	$data = $smof_data;

	do_action('optionsframework_admin_init_before', array(
			'of_options'		=> $of_options,
			'options_machine'	=> $options_machine,
			'smof_data'			=> $smof_data
		));
	do_action('optionsframework_admin_init_after', array(
			'of_options'		=> $of_options,
			'options_machine'	=> $options_machine,
			'smof_data'			=> $smof_data
		));

	$new_fields = false;
	foreach( $options_machine->Defaults as $field_name => $field_default ) {
		if( ! isset( $smof_data[$field_name] ) ) {
			$new_fields = true;
			$smof_data[$field_name] = $field_default;
		}
	}

	/**
	 * In Avada 3.7, we introduced backgroundcolor type.
	 *
	 * Here we are checking if a user is upgrading from < 3.7 and making 
	 * changes so that the new opacity field in background type is set to 
	 * default value but the color is retained from 3.6
	 */

	if( ! is_array( $smof_data['header_bg_color'] ) ) {
		$new_fields = true;

		$smof_data['header_bg_color'] = array(
			'color' => $smof_data['header_bg_color'],
			'opacity' => 1
		);
	}

	if( ! is_array( $smof_data['header_sticky_bg_color'] ) ) {
		$new_fields = true;

		$smof_data['header_sticky_bg_color'] = array(
			'color' => $smof_data['header_sticky_bg_color'],
			'opacity' => 0.97
		);
	}

	if( ! is_array( $smof_data['image_gradient_top_color'] ) ) {
		$new_fields = true;

		$smof_data['image_gradient_top_color'] = array(
			'color' => $smof_data['image_gradient_top_color'],
			'opacity' => 0.8
		);
	}

	if( ! is_array( $smof_data['slidingbar_bg_color'] ) ) {
		$new_fields = true;

		$smof_data['slidingbar_bg_color'] = array(
			'color' => $smof_data['slidingbar_bg_color'],
			'opacity' => 1
		);
	}
	
	if( $new_fields == true ) {
		of_save_options( $smof_data );
	}
}

/**
 * Create Options page
 *
 * @uses add_theme_page()
 * @uses add_action()
 *
 * @since 1.0.0
 */
function optionsframework_add_admin() {
	
	$of_page = add_theme_page( THEMENAME, 'Theme Options', 'edit_theme_options', 'optionsframework', 'optionsframework_options_page');

	// Add framework functionaily to the head individually
	add_action("admin_print_scripts-$of_page", 'of_load_only');
	add_action("admin_print_styles-$of_page",'of_style_only');
	
}


/**
 * Build Options page
 *
 * @since 1.0.0
 */
function optionsframework_options_page(){
	
	global $options_machine;
	
	/*
	//for debugging

	$smof_data = of_get_options();
	print_r($smof_data);

	*/	
	
	include_once( ADMIN_PATH . 'front-end/options.php' );

}

/**
 * Create Options page
 *
 * @uses wp_enqueue_style()
 *
 * @since 1.0.0
 */
function of_style_only(){
	$theme_info = wp_get_theme();
	wp_enqueue_style('admin-style', ADMIN_DIR . 'assets/css/admin-style.css', array(), $theme_info->get( 'Version' ));
	//wp_enqueue_style('color-picker', ADMIN_DIR . 'assets/css/colorpicker.css');
	wp_enqueue_style('jquery-ui-custom-admin', ADMIN_DIR .'assets/css/jquery-ui-custom.css', array(), $theme_info->get( 'Version' ));

	if ( !wp_style_is( 'wp-color-picker','registered' ) ) {
		wp_register_style( 'wp-color-picker', ADMIN_DIR . 'assets/css/color-picker.min.css', array(), $theme_info->get( 'Version' ) );
	}
	wp_enqueue_style( 'wp-color-picker' );
}	

/**
 * Create Options page
 *
 * @uses add_action()
 * @uses wp_enqueue_script()
 *
 * @since 1.0.0
 */
function of_load_only() 
{
	$theme_info = wp_get_theme();

	//add_action('admin_head', 'smof_admin_head');
	
	add_thickbox();
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('jquery-input-mask', ADMIN_DIR .'assets/js/jquery.maskedinput-1.2.2.js', array( 'jquery' ), $theme_info->get( 'Version' ));
	wp_enqueue_script('tipsy', ADMIN_DIR .'assets/js/jquery.tipsy.js', array( 'jquery' ), $theme_info->get( 'Version' ));
	//wp_enqueue_script('color-picker', ADMIN_DIR .'assets/js/colorpicker.js', array('jquery'));
	wp_enqueue_script('cookie', ADMIN_DIR . 'assets/js/cookie.js', 'jquery', $theme_info->get( 'Version' ));
	wp_enqueue_script('smof', ADMIN_DIR .'assets/js/smof.js', array( 'jquery' ), $theme_info->get( 'Version' ));
	if(defined('ICL_LANGUAGE_CODE')) {
		$vars = array(
			'wpml_custom_current_lang' => ICL_LANGUAGE_CODE,
		);
		wp_localize_script('smof', 'smof_wpml', $vars );
	}

	// Enqueue colorpicker scripts for versions below 3.5 for compatibility
	if ( !wp_script_is( 'wp-color-picker', 'registered' ) ) {
		wp_register_script( 'iris', ADMIN_DIR .'assets/js/iris.min.js', array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ), false, $theme_info->get( 'Version' ) );
		wp_register_script( 'wp-color-picker', ADMIN_DIR .'assets/js/color-picker.min.js', array( 'jquery', 'iris' ), $theme_info->get( 'Version' ) );
	}
	wp_enqueue_script( 'wp-color-picker' );
	

	/**
	 * Enqueue scripts for file uploader
	 */
	
	if ( function_exists( 'wp_enqueue_media' ) )
		wp_enqueue_media();
}


/**
 * Ajax Save Options
 *
 * @uses get_option()
 *
 * @since 1.0.0
 */
function of_ajax_callback() 
{
	global $options_machine, $of_options;

	$nonce=$_POST['security'];
	
	if (! wp_verify_nonce($nonce, 'of_ajax_nonce') ) die('-1'); 
			
	//get options array from db
	$all = of_get_options();
	
	$save_type = $_POST['type'];
	
	//echo $_POST['data'];
	
	//Uploads
	if($save_type == 'upload')
	{
		
		$clickedID = $_POST['data']; // Acts as the name
		$filename = $_FILES[$clickedID];
	   	$filename['name'] = preg_replace('/[^a-zA-Z0-9._\-]/', '', $filename['name']); 
		
		$override['test_form'] = false;
		$override['action'] = 'wp_handle_upload';	
		$uploaded_file = wp_handle_upload($filename,$override);
		 
			$upload_tracking[] = $clickedID;
				
			//update $options array w/ image URL			  
			$upload_image = $all; //preserve current data
			
			$upload_image[$clickedID] = $uploaded_file['url'];
			
			of_save_options($upload_image);
		
				
		 if(!empty($uploaded_file['error'])) { echo sprintf(__('Upload Error: %s', 'Avada'), __($uploaded_file['error'])); }	
		 else { echo $uploaded_file['url']; } // Is the Response
		 
	}
	elseif($save_type == 'image_reset')
	{
			
			$id = $_POST['data']; // Acts as the name
			
			$delete_image = $all; //preserve rest of data
			$delete_image[$id] = ''; //update array key with empty value	 
			of_save_options($delete_image ) ;
	
	}
	elseif($save_type == 'backup_options')
	{
			
		$backup = $all;
		$backup['backup_log'] = date('r');
		
		update_option(BACKUPS, $backup);
			
		die('1'); 
	}
	elseif($save_type == 'restore_options')
	{
			
		$smof_data = get_option(BACKUPS);

		update_option(OPTIONS, $smof_data);

		of_save_options($smof_data);
		
		die('1'); 
	}
	elseif($save_type == 'import_options'){

		$imported_data = $_POST['data'];
		$smof_data = unserialize(base64_decode($imported_data)); //100% safe - ignore theme check nag
		of_save_options($smof_data);

		
		die('1'); 
	}
	elseif ($save_type == 'save')
	{

		wp_parse_str(stripslashes($_POST['data']), $smof_data);
		unset($smof_data['security']);
		unset($smof_data['of_save']);
		of_save_options($smof_data);
		
		
		die('1');
	}
	elseif ($save_type == 'reset')
	{
		of_save_options($options_machine->Defaults);
		
		die('1'); //options reset
	}

  	die();
}
